DECLARE FUNCTION clock& ()
CONST pi = 3.141592653999997#
lives% = -1

' -- title screen
CLS
SCREEN 1
LINE (72, 68)-(251, 131), 1, B
LINE (73, 69)-(250, 130), 2, B
LOCATE 5, 18: PRINT "jenneygames.com"
LOCATE 6, 25: PRINT "presents"
LOCATE 13, 12: PRINT "Sine"
LOCATE 13, 26: PRINT "byte!"
LOCATE 20, 10: PRINT "Press any key to begin!"

LOCATE 23, 28: PRINT " CONTROLS "
LOCATE 23, 2: PRINT "ESC "
LOCATE 22, 12: PRINT " x 25  =  +1 LIFE"

VIEW (120, 20)-(195, 125)
WINDOW (0, 0)-(10, 20)

c% = -1
LINE (0, 0)-(10, 10), 1, , &HF0F
CIRCLE (5, 5), 1, 2, , , 1
PAINT STEP(0, 0), 2

WHILE INKEY$ = ""
  time! = clock&
  IF time! > prevtime! + 31 THEN
    prevtime! = time!
 
  r% = r% + 1
  IF r% = 360 THEN
    r% = 0
    c% = -c%
  END IF
  PSET (5, 5), 2
  PSET STEP(-SIN(r% * -(pi / 180)) * 5, -COS(r% * (pi / 180)) * 5), 1 - c%
  PSET (5, 5), 2
  PSET STEP(-SIN(r% * -(pi / 360)) * 5, -COS(r% * (pi / 360)) * 5), 2 - c%
END IF
WEND

VIEW
WINDOW
CLS

'-- game loop
WHILE quit% = 0
  time! = clock&
  IF time! > prevtime! + 31 THEN
    prevtime! = time!

  ' -- update key press
  k% = INP(96)
  IF k% = 1 THEN
   quit% = 1
  END IF

  IF lives% = -1 THEN
    RANDOMIZE TIMER
    CLS
    SCREEN 1
    x! = 160
    y! = 100
    level% = 1
    lives% = 5
    score% = 0
    r% = 0

    PLAY "MBT160O1L8CDEDCDL4ECC"
    LOCATE 14, 16: PRINT "  READY?  "
    LINE (120, 100)-(200, 114), 2, B
    SLEEP 2
  
    LINE (110, 100)-(217, 120), 0, BF
    CIRCLE (INT(RND * 300) + 10, INT(RND * 90) + 15), 5, 2, , , 1
    PAINT STEP(0, 0), 2

    LOCATE 1, 3: PRINT "Score:"; 0
    LOCATE 1, 18: PRINT "Level:"; 1
    LOCATE 1, 31: PRINT "Lives:"; 5

  END IF

  ' -- logic for key press
  IF k% = 75 THEN
    IF r% = 360 THEN r% = 0
    r% = r% + 4
  END IF
  IF k% = 77 THEN r% = r% - 4
  IF r% = 0 THEN r% = 360
 
  ' -- update new x/y
  x! = x! + SIN(r% * (pi / 180))
  y! = y! + COS(r% * (pi / 180))
 
  ' -- get pixel color of x/y
  c% = POINT(x!, y!)
 
  'apple
  IF c% = 2 THEN
    ' -- erase apple
    PAINT STEP(0, 0), 0
    score% = score% + 1
    LOCATE 1, 3: PRINT "Score:"; score% * 10

    ' -- new level
    IF (score% MOD 5 = 0) THEN
      level% = level% + 1
      LOCATE 1, 18: PRINT "Level:"; level%;
     
      SELECT CASE level%
        ' -- friendly beginner level
        CASE 2
          LINE (0, 10)-(319, 199), 0, BF
          LINE (120, 90)-(200, 94), 1, BF
        ' -- fence border
        CASE 10
          LINE (1, 10)-(319, 199), 1, B, &HF8
        ' -- increasing difficulty
        CASE ELSE
          IF (level% + (level% \ 10)) MOD 4 = 0 THEN
              LINE (0, 10)-(319, 199), 0, BF
          END IF
         
          FOR i% = 1 TO 1000
            x% = INT(RND * 268) + 50
            y% = INT(RND * 128) + 50
            IF x% > 100 AND x% < 225 AND y% > 75 AND y% < 150 THEN
             ' -- attempt to safely spawn (area is protected)
            ELSE
              ' -- set random position for spawning obstacle
              PSET (x%, y%), 1
              i% = 1000
            END IF
          NEXT i%

          ' -- random obstacle orientation and size
          IF INT(RND * 2) + 1 = 1 THEN
            LINE STEP(0, 0)-STEP(5, INT(RND * 40) + 30), 1, BF
          ELSE
            LINE STEP(0, 0)-STEP(INT(RND * 40) + 30, 5), 1, BF
          END IF
      END SELECT

      ' -- logic section for lives AND fence border
      IF score% MOD 2 = 0 THEN
       
        ' -- fence border
        IF level% > 10 THEN
          IF level% MOD 5 = 0 THEN
            LINE (0, 10)-(319, 199), 1, B, &HF8
          END IF
        END IF

        lives% = lives% + 1
        LOCATE 1, 31: PRINT "Lives:"; lives%
        SOUND 100, 1
        SOUND 600, 1
        SOUND 1200, 1
        SOUND 100, 1
        SOUND 800, 1
        SOUND 1600, 1
      ELSE
        SOUND 200, 1
        SOUND 300, 1
        SOUND 400, 1
        SOUND 200, 1
        SOUND 400, 1
        SOUND 600, 1
        SOUND 200, 1
        SOUND 600, 1
        SOUND 900, 1
      END IF
    ELSE
      SOUND 200, 1
      SOUND 250, 1
      SOUND 300, 1
    END IF
   
    ' -- spawn new circle in a new random location
    '    (freebie/unexpected behavior/bug: spawns more than one?)
    CIRCLE (INT(RND * 300) + 10, INT(RND * 175) + 15), 5, 2, , , 1
    PAINT STEP(0, 0), 2
  END IF


  ' collision!
  IF c% = 1 THEN

    lives% = lives% - 1
    LOCATE 1, 31: PRINT "Lives:"; lives%
   
    r% = 0
    CIRCLE STEP(0, 0), 5, 1, 1, , 1
    CIRCLE STEP(0, 0), 4, 1, 1, , 1
    CIRCLE STEP(0, 0), 3, 1, 1, , 1
    CIRCLE STEP(0, 0), 2, 1, 1, , 1
    CIRCLE STEP(0, 0), 1, 1, 1, , 1
    SOUND 300, 1
    SOUND 200, 1
    SOUND 100, 1
   
    ' -- end of game
    IF lives% = 0 THEN
      LINE (110, 90)-(227, 124), 2, BF
      LINE (112, 92)-(225, 122), 0, BF
     
      OPEN "score.dat" FOR RANDOM AS #1 LEN = LEN(score%)
      GET #1, 1, oldscore%
      IF oldscore% < score% THEN
        PUT #1, 1, score%
        LOCATE 13, 15: PRINT "  NEW HIGH"
        LOCATE 14, 15: PRINT "  SCORE:"; score% * 10;
      ELSE
        LOCATE 13, 15: PRINT "  GAME OVER"
        LOCATE 14, 15: PRINT "  BEST:"; oldscore% * 10;
      END IF
      CLOSE #1
     
      LOCATE 15, 15: PRINT "  ESC/PLAY+ "
      WHILE k% = 75 OR k% = 77
        k% = INP(96)
        SLEEP 1
      WEND
      SLEEP

      '-- does the player want to stop playing (for now?)
      k% = INP(96)
      IF k% = 1 THEN
        quit% = 1
      ELSE
        lives% = -1
      END IF

    END IF

    ' -- reset player position
    x! = 160
    y! = 100

  END IF

  ' -- wrap level edges
  IF y! > 199 THEN
    y! = 10
    SOUND 400, 1
  ELSEIF y! < 10 THEN
    y! = 199
    SOUND 400, 1
  END IF

  IF x! > 319 THEN
    x! = 1
    SOUND 400, 1
  ELSEIF x! < 1 THEN
    x! = 319
    SOUND 400, 1
  END IF
 
  ' -- draw player
  PSET (x!, y!)

END IF
WEND

' -- game exit
CLS
SCREEN 1
LINE (68, 90)-(260, 126), 2, B
LOCATE 13, 10: PRINT "  THANKS FOR PLAYING!  "
LOCATE 15, 10: PRINT " visit jenneygames.com "
SLEEP

FUNCTION clock&

  '-- number of timer ticks at 0000:046C
  DEF SEG = 0
  ticks& = PEEK(&H46C)
  ticks& = ticks& + PEEK(&H46D) * 256
  ticks& = ticks& + PEEK(&H46E) * 65536
  DEF SEG

  '-- latch counter & obtain PIT countdown status
  OUT &H43, &H4
  LSB = INP(&H40)
  HSB = 255 - INP(&H40)

  '-- compute value
  clock& = ticks& * 256 + HSB

END FUNCTION

